# scripts/aggregate_string_tension.py
import csv, glob, os, sys

root = sys.argv[1] if len(sys.argv) > 1 else "data/results/vol4_discrete_gauge_wilson_loop"
out  = os.path.join(root, "summary_all.csv")

paths = glob.glob(os.path.join(root, "L*", "b*_k*_n0*", "string_tension_summary.csv"))
if not paths:
    print("No per-job summaries found.")
    raise SystemExit(1)

fieldnames = None
with open(out, "w", newline="", encoding="utf-8") as fo:
    writer = None
    for p in paths:
        with open(p, newline="", encoding="utf-8") as fi:
            r = csv.DictReader(fi)
            if fieldnames is None:
                fieldnames = r.fieldnames
                writer = csv.DictWriter(fo, fieldnames=fieldnames)
                writer.writeheader()
            for row in r:
                writer.writerow(row)

print(f"Wrote {out} from {len(paths)} job files.")
